IF  EXISTS(
	SELECT 
		1 
	FROM 
		SYS.OBJECTS 
	WHERE 
		NAME LIKE 'UFD_EST_PROD_PRECIFICACAO_META_MARGEM' AND TYPE = 'TF' )
BEGIN
	DROP FUNCTION UFD_EST_PROD_PRECIFICACAO_META_MARGEM
END
GO
--SELECT * FROM UFD_EST_PROD_PRECIFICACAO_META_MARGEM (1,2,7)
CREATE FUNCTION [dbo].[UFD_EST_PROD_PRECIFICACAO_META_MARGEM]  (@CD_EMP   INT,    
          @CD_GRUPO  INT,    
          @CD_PROD  INT)
 RETURNS @RS_RET TABLE (CD_PROD INT,
					     CD_GRUPO INT,
					     TP_NIVEL_PERC INT,
					     PERC_MARGEM MONEY,
					     DS_PERC_MARGEM VARCHAR(100))

AS              
BEGIN 

	 DECLARE @RS_TAB_COMIS TABLE (CD_PROD INT,
							CD_GRUPO INT,
							TP_NIVEL_PERC INT,
							PERC_MARGEM MONEY,
							DS_PERC_MARGEM VARCHAR(50))
	
	DECLARE @TBL_NIVEL TABLE ( TP_NIVEL INT,
						 DS_NIVEL VARCHAR(20))
	INSERT INTO @TBL_NIVEL 
		SELECT 1, 'PRODUTO' UNION
		SELECT 2, 'FAMILIA' UNION
		SELECT 3, 'MARCA' UNION
		SELECT 4, 'FABRICANTE' UNION
		SELECT 5, 'CATEGORIA' UNION
		SELECT 6, 'LINHA'	

	INSERT INTO @RS_TAB_COMIS
		SELECT	A.CD_PROD,
				A.CD_GRUPO,
				A.TP_NIVEL,
				A.PERC_MARGEM,			
				'' AS DS_PERC_MARGEM
		FROM UFD_EST_PROD_PRECIFICACAO_META_MARGEM_VALORES(@CD_EMP,@CD_GRUPO, @CD_PROD) A


	INSERT INTO @RS_RET
	SELECT 
		MAX(CD_PROD) AS CD_PROD,
		MAX(CD_GRUPO) AS CD_GRUPO,
		MAX(TP_NIVEL_PERC) AS TP_NIVEL_PERC,
		MAX(PERC_MARGEM)	 AS PERC_MARGEM,		
			 (CASE WHEN MAX(ISNULL(PERC_MARGEM,0)) = 0 AND MAX(CD_GRUPO) > 0 THEN 
					'PARAMETRO DE METAS MARGEM ANULADA(%) PELO NIVEL - TAB: ' + CAST(MAX(CD_GRUPO) AS VARCHAR) + ' NIVEL: ' + (SELECT DS_NIVEL FROM @TBL_NIVEL N WHERE N.TP_NIVEL = MAX(T.TP_NIVEL_PERC))
			 WHEN MAX(ISNULL(PERC_MARGEM,0)) = 0 AND MAX(CD_GRUPO) = 0 THEN 
					'SEM COMISSAO(%)'
			 WHEN MAX(ISNULL(PERC_MARGEM,0)) > 0 AND MAX(CD_GRUPO) > 0 THEN 
					'PARAMETRO DE METAS MARGEM(%) - TAB: ' + CAST(MAX(CD_GRUPO) AS VARCHAR) + ' NIVEL: ' + (SELECT DS_NIVEL FROM @TBL_NIVEL N WHERE N.TP_NIVEL = MAX(T.TP_NIVEL_PERC))
			 ELSE
				'NAO DEFINIDO'
			END) AS DS_PERC_MARGEM
	FROM @RS_TAB_COMIS T

	DELETE FROM @RS_RET WHERE CD_PROD IS NULL

RETURN
END 